/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.datatransfer;

import filenet.vw.api.VWException;
import filenet.vw.toolkit.utils.datatransfer.IVWCBData;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Vector;

public class VWTransferable
implements Transferable,
ClipboardOwner {
    private String m_data = null;
    private Vector m_dataFlavors = new Vector();
    public static final DataFlavor XML_DATAFLAVOR = new DataFlavor("text/xml; charset=unicode", "XML");

    public VWTransferable(String data) throws VWException {
        if (data == null) {
            throw new VWException("vw.toolkit.utils.datatransfer.VWTransferable", "The data cannot be null.");
        }
        this.m_data = data;
    }

    public Object getTransferData(DataFlavor flavor) {
        if (flavor.equals(DataFlavor.stringFlavor) || flavor.equals(XML_DATAFLAVOR)) {
            return this.m_data;
        }
        for (int index = 0; index < this.m_dataFlavors.size(); ++index) {
            IVWCBData cbContent = (IVWCBData)this.m_dataFlavors.elementAt(index);
            if (!flavor.equals(cbContent.getDataFlavor())) continue;
            return cbContent;
        }
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavors = new DataFlavor[this.m_dataFlavors.size() + 1];
        for (int index = 0; index < this.m_dataFlavors.size(); ++index) {
            dataFlavors[index] = ((IVWCBData)this.m_dataFlavors.elementAt(index)).getDataFlavor();
        }
        dataFlavors[index++] = DataFlavor.stringFlavor;
        return dataFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.getTransferData(flavor) != null;
    }

    public void addDataFlavor(IVWCBData cbContent) throws VWException {
        if (cbContent == null) {
            throw new VWException("vw.toolkit.utils.datatransfer.VWTransferable", "Cannot add the specified data flavor.");
        }
        cbContent.setContent(this.m_data);
        this.m_dataFlavors.addElement(cbContent);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

